/*
 * Decompiled with CFR 0.152.
 */
package com.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.TextureMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.game.App;
import com.game.actor.Base;
import com.game.actor.Enemy;
import com.game.actor.Player;
import com.game.actor.object.Platform;
import com.game.managers.ScreenManager;
import com.game.misc.Vars;
import com.game.misc.utils.Box2dUtils;
import com.game.misc.utils.CameraUtils;
import com.game.misc.utils.myButton;
import com.game.misc.utils.myWindow;
import com.game.screens.AbstractScreen;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Play
extends AbstractScreen {
    private GameState curGameState;
    private World world;
    public boolean isDebug = false;
    private Box2DDebugRenderer b2dr;
    private OrthographicCamera b2dCam;
    private TiledMap tileMap;
    private OrthogonalTiledMapRenderer tmr;
    private float mapWidth;
    private float mapHeight;
    private Vector2 tileSize;
    private int levelNumber;
    private Player player;
    private ArrayList<Platform> platforms = new ArrayList();
    private ArrayList<Enemy> enemies = new ArrayList();
    private Skin skin;
    private HashMap<GameState, myWindow> windows = new HashMap();
    private Rectangle progressRect;
    private Texture progressTexture;
    private float percent;
    private float progressX;
    private Image uiRedImage;
    private Image uiGreenImage;
    private Image uiBlueImage;
    private int score = 0;
    private float scoreYPos = 100.0f;
    ContactListener cl = new ContactListener(){

        @Override
        public void beginContact(Contact contact) {
            Fixture fa = contact.getFixtureA();
            Fixture fb = contact.getFixtureB();
            if (fa == null || fb == null) {
                return;
            }
            if (fa.getUserData() == null || fb.getUserData() == null) {
                return;
            }
            if ((fa.getUserData().equals("PLAYER") && fb.getUserData().equals("PLATFORM") || fb.getUserData().equals("PLAYER") && fa.getUserData().equals("PLATFORM")) && Play.this.player.getCurAction() != Player.Action.IDLE) {
                Play.this.player.setAction(Player.Action.IDLE);
                return;
            }
            if (fa.getUserData().equals("PLAYER") && fb.getUserData().equals("ENEMY") || fb.getUserData().equals("PLAYER") && fa.getUserData().equals("ENEMY")) {
                for (Enemy e : Play.this.enemies) {
                    if (!e.getFixtures().contains(fa, false) && !e.getFixtures().contains(fb, false) || !e.isAlive()) continue;
                    e.setAlive(false);
                    e.setCurColour(e.getCurColour());
                    Play.this.score = Play.this.score + 100;
                    System.out.println(Play.this.score);
                }
            }
            if (fa.getUserData().equals("PLAYER") && fb.getUserData().equals("PASSBOUNDARY") || fb.getUserData().equals("PLAYER") && fa.getUserData().equals("PASSBOUNDARY")) {
                Play.this.score = Play.this.score + 1000;
                Play.this.setCurGameState(GameState.SUCCESS);
                System.out.println("SUCCESS");
                return;
            }
            if (fa.getUserData().equals("PLAYER") && fb.getUserData().equals("FAILBOUNDARY") || fb.getUserData().equals("PLAYER") && fa.getUserData().equals("FAILBOUNDARY")) {
                Play.this.setCurGameState(GameState.FAILURE);
                System.out.println("FAILURE - TOUCHED FAILBOUNDARY");
                return;
            }
        }

        @Override
        public void endContact(Contact contact) {
        }

        @Override
        public void preSolve(Contact contact, Manifold oldManifold) {
        }

        @Override
        public void postSolve(Contact contact, ContactImpulse impulse) {
        }
    };

    public Play(App app, int levelNumber) {
        super(app);
        this.levelNumber = levelNumber;
        this.skin = new Skin();
        this.world = new World(new Vector2(0.0f, Vars.GRAVITY.y), true);
        this.world.setContactListener(this.cl);
        this.b2dr = new Box2DDebugRenderer();
        this.b2dCam = new OrthographicCamera();
        this.b2dCam.setToOrtho(false, 12.8f, 7.2f);
    }

    @Override
    public void show() {
        super.show();
        this.skin.add("default-font", App.assets.get("badaboom60.ttf", BitmapFont.class));
        this.skin.load(Gdx.files.internal("spritesheets/uiskin.json"));
        this.progressRect = new Rectangle(this.stage.getWidth() - 550.0f, this.stage.getHeight() - 50.0f, 0.0f, 25.0f);
        this.progressTexture = App.assets.get("textures/player/player_red.png", Texture.class);
        this.progressX = this.progressRect.x;
        this.uiRedImage = new Image(App.assets.get("textures/player/player_red.png", Texture.class));
        this.uiRedImage.setPosition(84.0f, this.stage.getHeight() - 70.0f);
        this.uiGreenImage = new Image(App.assets.get("textures/player/player_green.png", Texture.class));
        this.uiGreenImage.setPosition(148.0f, this.stage.getHeight() - 70.0f);
        this.uiBlueImage = new Image(App.assets.get("textures/player/player_blue.png", Texture.class));
        this.uiBlueImage.setPosition(212.0f, this.stage.getHeight() - 70.0f);
        this.uiRedImage.setSize(64.0f, 64.0f);
        this.uiGreenImage.setSize(32.0f, 32.0f);
        this.uiBlueImage.setSize(32.0f, 32.0f);
        this.initLevel();
        this.initWindows();
        this.setCurGameState(GameState.INTRO);
    }

    @Override
    public void update(float dt) {
        if (this.curGameState == GameState.PLAYING) {
            this.world.step(0.016666668f, 6, 2);
            CameraUtils.lerpToTarget(this.cam, this.player.getPos().scl((float)100.0f).x, 0.0f);
            CameraUtils.lerpToTarget(this.b2dCam, this.player.getPos().x, this.player.getPos().y);
            Vector2 start = new Vector2(this.cam.viewportWidth / 2.0f, this.cam.viewportHeight / 2.0f);
            CameraUtils.setBoundary(this.cam, start, new Vector2(this.mapWidth * this.tileSize.x - start.x * 2.0f, this.mapHeight * this.tileSize.y - start.y * 2.0f));
            this.percent = Interpolation.linear.apply(this.percent, this.player.getPos().x * 100.0f / (this.mapWidth * this.tileSize.x), 0.2f);
            this.progressX = this.progressRect.x + 500.0f * this.percent - this.player.getSize().x / 2.0f;
            this.player.update(dt);
        }
        this.stage.act(dt);
    }

    @Override
    public void render(float dt) {
        super.render(dt);
        this.app.sb.setProjectionMatrix(this.cam.combined);
        if (!this.isDebug) {
            this.app.sb.begin();
            this.app.sb.draw(App.assets.get("textures/backgrounds/position0.png", Texture.class), this.cam.position.x - this.cam.viewportWidth / 2.0f, this.cam.position.y - this.cam.viewportHeight / 2.0f);
            this.app.sb.draw(App.assets.get("textures/backgrounds/position1.png", Texture.class), this.cam.position.x - this.cam.viewportWidth / 2.0f, this.cam.position.y - this.cam.viewportHeight / 2.0f + 75.0f);
            this.app.sb.draw(App.assets.get("textures/backgrounds/position2.png", Texture.class), this.cam.position.x - this.cam.viewportWidth / 2.0f, this.cam.position.y - this.cam.viewportHeight / 2.0f - 150.0f);
            this.player.render(this.app.sb);
            for (Enemy e : this.enemies) {
                e.render(this.app.sb);
            }
            this.app.sb.end();
            this.tmr.setView(this.cam);
            this.tmr.render();
            this.app.sb.setProjectionMatrix(this.hudCam.combined);
            this.app.sr.begin(ShapeRenderer.ShapeType.Filled);
            this.app.sr.setColor(1.0f, 0.0f, 0.0f, 1.0f);
            this.app.sr.rect(this.progressRect.x, this.progressRect.y, this.progressRect.width, this.progressRect.height);
            this.app.sr.set(ShapeRenderer.ShapeType.Line);
            this.app.sr.rect(this.progressRect.x, this.progressRect.y, 500.0f, this.progressRect.height);
            this.app.sr.end();
            this.app.sb.begin();
            this.uiRedImage.draw(this.app.sb, 1.0f);
            this.uiGreenImage.draw(this.app.sb, 1.0f);
            this.uiBlueImage.draw(this.app.sb, 1.0f);
            this.app.sb.draw(this.progressTexture, this.progressX, this.progressRect.y, 30.0f, 30.0f);
            App.assets.get("badaboom60.ttf", BitmapFont.class).draw((Batch)this.app.sb, "Score: " + this.score, 500.0f, this.scoreYPos);
            this.app.sb.end();
        } else {
            this.b2dr.render(this.world, this.b2dCam.combined);
        }
        this.stage.draw();
    }

    @Override
    public void handleInput() {
        if (this.curGameState == GameState.PLAYING) {
            if (Gdx.input.isKeyPressed(62)) {
                this.player.jump();
            }
            if (Gdx.input.isKeyJustPressed(8)) {
                this.changeColour(Base.Colours.RED);
            }
            if (Gdx.input.isKeyJustPressed(9)) {
                this.changeColour(Base.Colours.GREEN);
            }
            if (Gdx.input.isKeyJustPressed(10)) {
                this.changeColour(Base.Colours.BLUE);
            }
        }
        if (Gdx.input.isKeyJustPressed(131)) {
            if (this.curGameState == GameState.PAUSED) {
                this.setCurGameState(GameState.PLAYING);
            } else {
                this.setCurGameState(GameState.PAUSED);
            }
        }
        if (this.curGameState == GameState.INTRO && Gdx.input.isKeyPressed(62)) {
            this.setCurGameState(GameState.PLAYING);
        }
        if (Gdx.input.isKeyJustPressed(52)) {
            this.isDebug = !this.isDebug;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.world.dispose();
        this.b2dr.dispose();
        this.tileMap.dispose();
        this.tmr.dispose();
    }

    private void changeColour(Base.Colours curColour) {
        this.player.setCurColour(curColour);
        switch (curColour) {
            case RED: {
                this.progressTexture = App.assets.get("textures/player/player_red.png", Texture.class);
                this.uiRedImage.setSize(64.0f, 64.0f);
                this.uiGreenImage.setSize(32.0f, 32.0f);
                this.uiBlueImage.setSize(32.0f, 32.0f);
                break;
            }
            case GREEN: {
                this.progressTexture = App.assets.get("textures/player/player_green.png", Texture.class);
                this.uiGreenImage.setSize(64.0f, 64.0f);
                this.uiRedImage.setSize(32.0f, 32.0f);
                this.uiBlueImage.setSize(32.0f, 32.0f);
                break;
            }
            case BLUE: {
                this.progressTexture = App.assets.get("textures/player/player_blue.png", Texture.class);
                this.uiBlueImage.setSize(64.0f, 64.0f);
                this.uiGreenImage.setSize(32.0f, 32.0f);
                this.uiRedImage.setSize(32.0f, 32.0f);
            }
        }
    }

    private void initLevel() {
        this.tileMap = new TmxMapLoader().load("levels/level" + this.levelNumber + ".tmx");
        this.tmr = new OrthogonalTiledMapRenderer(this.tileMap);
        MapProperties mapProp = this.tileMap.getProperties();
        this.mapWidth = mapProp.get("width", Integer.class).intValue();
        this.mapHeight = mapProp.get("height", Integer.class).intValue();
        this.tileSize = new Vector2(mapProp.get("tilewidth", Integer.class).intValue(), mapProp.get("tileheight", Integer.class).intValue());
        TiledMapTileLayer platformLayer = (TiledMapTileLayer)this.tileMap.getLayers().get("PLATFORM");
        MapLayer boundaryLayer = this.tileMap.getLayers().get("BOUNDARY");
        PolylineMapObject polylineObj = (PolylineMapObject)boundaryLayer.getObjects().get(0);
        this.initBoundary(polylineObj, "BOUNDARY", false);
        boundaryLayer = this.tileMap.getLayers().get("FAILBOUNDARY");
        polylineObj = (PolylineMapObject)boundaryLayer.getObjects().get(0);
        this.initBoundary(polylineObj, "FAILBOUNDARY", true);
        boundaryLayer = this.tileMap.getLayers().get("PASSBOUNDARY");
        polylineObj = (PolylineMapObject)boundaryLayer.getObjects().get(0);
        this.initBoundary(polylineObj, "PASSBOUNDARY", true);
        MapLayer playerLayer = this.tileMap.getLayers().get("PLAYER");
        TextureMapObject playerObj = (TextureMapObject)playerLayer.getObjects().get(0);
        this.player = new Player(this.world, new Vector2(playerObj.getX(), playerObj.getY()), new Vector2(60.0f, 60.0f), Base.Colours.WHITE);
        MapLayer enemyLayer = this.tileMap.getLayers().get("ENEMIES");
        MapObjects enemyObjs = enemyLayer.getObjects();
        for (int i = 0; i < enemyObjs.getCount(); ++i) {
            TextureMapObject tmo = (TextureMapObject)enemyObjs.get(i);
            MapProperties mp = tmo.getProperties();
            if (mp.get("Colour").equals("RED")) {
                this.enemies.add(new Enemy(this.world, new Vector2(tmo.getX() + 32.0f, tmo.getY() + 32.0f), new Vector2(64.0f, 64.0f), Base.Colours.RED, 1, 1));
                continue;
            }
            if (mp.get("Colour").equals("GREEN")) {
                this.enemies.add(new Enemy(this.world, new Vector2(tmo.getX() + 32.0f, tmo.getY() + 32.0f), new Vector2(64.0f, 64.0f), Base.Colours.GREEN, 1, 1));
                continue;
            }
            if (!mp.get("Colour").equals("BLUE")) continue;
            this.enemies.add(new Enemy(this.world, new Vector2(tmo.getX() + 32.0f, tmo.getY() + 32.0f), new Vector2(64.0f, 64.0f), Base.Colours.GREEN, 1, 1));
        }
        for (int row = 0; row < platformLayer.getHeight(); ++row) {
            for (int col = 0; col < platformLayer.getWidth(); ++col) {
                TiledMapTileLayer.Cell cell = platformLayer.getCell(col, row);
                if (cell == null || cell.getTile() == null) continue;
                if (cell.getTile().getId() == 1) {
                    this.platforms.add(new Platform(this.world, new Vector2(((float)col + 0.5f) * this.tileSize.x, ((float)row + 0.5f) * this.tileSize.y), new Vector2(this.tileSize.x, this.tileSize.y), Base.Colours.RED, 2, 1));
                    continue;
                }
                if (cell.getTile().getId() == 2) {
                    this.platforms.add(new Platform(this.world, new Vector2(((float)col + 0.5f) * this.tileSize.x, ((float)row + 0.5f) * this.tileSize.y), new Vector2(this.tileSize.x, this.tileSize.y), Base.Colours.GREEN, 4, 1));
                    continue;
                }
                if (cell.getTile().getId() == 3) {
                    this.platforms.add(new Platform(this.world, new Vector2(((float)col + 0.5f) * this.tileSize.x, ((float)row + 0.5f) * this.tileSize.y), new Vector2(this.tileSize.x, this.tileSize.y), Base.Colours.BLUE, 8, 1));
                    continue;
                }
                if (cell.getTile().getId() != 4) continue;
                this.platforms.add(new Platform(this.world, new Vector2(((float)col + 0.5f) * this.tileSize.x, ((float)row + 0.5f) * this.tileSize.y), new Vector2(this.tileSize.x, this.tileSize.y), Base.Colours.WHITE, 1, 1));
            }
        }
    }

    private void initBoundary(PolylineMapObject polylineObj, String userData, boolean isSensor) {
        Polyline r = polylineObj.getPolyline();
        BodyDef bd = new BodyDef();
        bd.type = BodyDef.BodyType.StaticBody;
        Body body = this.world.createBody(bd);
        float[] v = r.getTransformedVertices();
        Vector2[] finalV = new Vector2[v.length / 2];
        for (int i = 0; i < v.length / 2; ++i) {
            finalV[i] = new Vector2();
            finalV[i].x = v[i * 2] / 100.0f;
            finalV[i].y = v[i * 2 + 1] / 100.0f;
        }
        Box2dUtils.makeChain(body, finalV, userData, isSensor, (short)1, (short)1);
    }

    private void initWindows() {
        Vector2 winPos = new Vector2(280.0f, 50.0f);
        Vector2 winSize = new Vector2(700.0f, 500.0f);
        this.windows.put(GameState.PLAYING, new myWindow("", new Vector2(0.0f, 0.0f), new Vector2(0.0f, 0.0f), this.skin, App.assets.get("textures/player/player_red.png", Texture.class)));
        this.windows.put(GameState.INTRO, new myWindow("Level " + this.levelNumber, winPos, winSize, this.skin, App.assets.get("textures/intros/level" + this.levelNumber + "Intro.png", Texture.class)));
        this.windows.put(GameState.PAUSED, new myWindow("", winPos, winSize, this.skin, App.assets.get("textures/backgrounds/pauseBackground.png", Texture.class)));
        this.windows.put(GameState.SUCCESS, new myWindow("", winPos, winSize, this.skin, App.assets.get("textures/backgrounds/successBackground.png", Texture.class)));
        this.windows.put(GameState.FAILURE, new myWindow("", winPos, winSize, this.skin, App.assets.get("textures/backgrounds/failureBackground.png", Texture.class)));
        myWindow tempWindow = this.windows.get((Object)GameState.INTRO);
        tempWindow.addButton(new myButton("Continue", new Vector2(tempWindow.getX() * 2.0f - 5.0f, tempWindow.getHeight() - 50.0f), this.skin, "intro", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.setCurGameState(GameState.PLAYING);
            }
        }));
        tempWindow = this.windows.get((Object)GameState.PAUSED);
        tempWindow.addButton(new myButton("Continue", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 290.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.setCurGameState(GameState.PLAYING);
            }
        }));
        tempWindow.addButton(new myButton("Reset", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 190.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.app.sm.setPlayScreen(Play.this.levelNumber);
            }
        }));
        tempWindow.addButton(new myButton("Exit", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 90.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.app.sm.setScreen(ScreenManager.Screen.MENU);
            }
        }));
        tempWindow = this.windows.get((Object)GameState.SUCCESS);
        tempWindow.addButton(new myButton("Continue", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 290.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.app.sm.setPlayScreen(Play.this.levelNumber + 1);
            }
        }));
        tempWindow.addButton(new myButton("Reset", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 190.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.app.sm.setPlayScreen(Play.this.levelNumber);
            }
        }));
        tempWindow.addButton(new myButton("Exit", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 90.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.app.sm.setScreen(ScreenManager.Screen.MENU);
            }
        }));
        tempWindow = this.windows.get((Object)GameState.FAILURE);
        tempWindow.addButton(new myButton("Reset", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 190.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.app.sm.setPlayScreen(Play.this.levelNumber);
            }
        }));
        tempWindow.addButton(new myButton("Exit", new Vector2(tempWindow.getX() / 2.0f - 25.0f, 90.0f), this.skin, "default", new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Play.this.app.sm.setScreen(ScreenManager.Screen.MENU);
            }
        }));
        for (myWindow w : this.windows.values()) {
            this.stage.addActor(w);
        }
    }

    private void setCurGameState(GameState newGameState) {
        if (this.curGameState != null) {
            this.windows.get((Object)this.curGameState).setVisible(false);
        }
        this.curGameState = newGameState;
        System.out.println("Showing: " + this.curGameState.name() + " window");
        this.windows.get((Object)this.curGameState).setVisible(true);
        if (this.curGameState == GameState.SUCCESS) {
            this.scoreYPos = 650.0f;
            try {
                FileWriter leaderboard = new FileWriter("Leaderboard.csv", true);
                leaderboard.append("Level " + this.levelNumber + "," + this.score + ",\n");
                leaderboard.flush();
                leaderboard.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum GameState {
        PLAYING,
        INTRO,
        PAUSED,
        SUCCESS,
        FAILURE;

    }
}

