/*
 * Decompiled with CFR 0.152.
 */
package com.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.game.App;
import com.game.managers.ScreenManager;
import com.game.screens.AbstractScreen;

public class Menu
extends AbstractScreen {
    private Skin skin = new Skin();
    private TextButton butPlay;
    private TextButton butExit;
    private TextButton butLeaderboard;
    private Vector2 buttonSize = new Vector2(50.0f, 50.0f);
    private Music music;

    public Menu(App app) {
        super(app);
    }

    @Override
    public void show() {
        super.show();
        this.skin.add("default-font", App.assets.get("badaboom60.ttf", BitmapFont.class));
        this.skin.load(Gdx.files.internal("spritesheets/uiskin.json"));
        this.music = App.assets.get("music/TheComplex.mp3", Music.class);
        this.music.setLooping(true);
        this.initButtons();
        this.music.play();
    }

    @Override
    public void update(float dt) {
        this.stage.act(dt);
    }

    @Override
    public void render(float dt) {
        super.render(dt);
        this.app.sb.begin();
        this.app.sb.draw(App.assets.get("textures/backgrounds/menuBackground.jpg", Texture.class), 0.0f, 0.0f);
        this.app.sb.end();
        this.stage.draw();
    }

    @Override
    public void handleInput() {
        if (Gdx.input.isKeyJustPressed(131)) {
            Gdx.app.exit();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void initButtons() {
        this.butPlay = new TextButton("Play", this.skin, "default");
        this.butPlay.setPosition(this.stage.getWidth() / 2.0f - this.buttonSize.x / 2.0f, this.buttonSize.y + 160.0f);
        this.butPlay.setSize(this.buttonSize.x, this.buttonSize.y);
        this.butPlay.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Menu.this.app.sm.setScreen(ScreenManager.Screen.LEVELSELECT);
            }
        });
        this.butLeaderboard = new TextButton("Leaderboard", this.skin, "default");
        this.butLeaderboard.setPosition(this.stage.getWidth() / 2.0f - this.buttonSize.x / 2.0f, this.buttonSize.y + 80.0f);
        this.butLeaderboard.setSize(this.buttonSize.x, this.buttonSize.y);
        this.butLeaderboard.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Menu.this.app.sm.setScreen(ScreenManager.Screen.LEADERBOARD);
            }
        });
        this.butExit = new TextButton("Exit", this.skin, "default");
        this.butExit.setPosition(this.stage.getWidth() / 2.0f - this.buttonSize.x / 2.0f, this.buttonSize.y);
        this.butExit.setSize(this.buttonSize.x, this.buttonSize.y);
        this.butExit.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Gdx.app.exit();
            }
        });
        this.stage.addActor(this.butPlay);
        this.stage.addActor(this.butLeaderboard);
        this.stage.addActor(this.butExit);
    }
}

