/*
 * Decompiled with CFR 0.152.
 */
package com.game.screens;

import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Rectangle;
import com.game.App;
import com.game.managers.ScreenManager;
import com.game.screens.AbstractScreen;
import java.io.FileWriter;
import java.io.IOException;

public class Loading
extends AbstractScreen {
    private float percent;
    private Rectangle loadingRect;
    private Texture logo;

    public Loading(App app) {
        super(app);
    }

    @Override
    public void show() {
        super.show();
        InternalFileHandleResolver resolver = new InternalFileHandleResolver();
        App.assets.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        App.assets.setLoader(BitmapFont.class, ".ttf", new FreetypeFontLoader(resolver));
        this.loadFont("fonts/badaboom.TTF", 60, Color.BLACK);
        App.assets.load("textures/player/player_red.png", Texture.class);
        App.assets.finishLoading();
        this.logo = App.assets.get("textures/player/player_red.png", Texture.class);
        this.loadingRect = new Rectangle(this.stage.getWidth() / 6.0f, this.stage.getHeight() / 2.0f - 25.0f, 0.0f, 25.0f);
        this.assetsToLoad();
    }

    @Override
    public void update(float dt) {
        this.percent = Interpolation.linear.apply(this.percent, App.assets.getProgress(), 0.3f);
        System.out.println("Loading...  " + App.assets.getProgress() * 100.0f + "%");
        this.loadingRect.width = 0.0f + 853.3333f * this.percent;
        if (App.assets.update() && this.loadingRect.width >= 852.0f) {
            this.app.sm.setScreen(ScreenManager.Screen.MENU);
        }
    }

    @Override
    public void render(float dt) {
        super.render(dt);
        this.app.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.app.sr.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        this.app.sr.rect(this.loadingRect.x, this.loadingRect.y, this.loadingRect.width, this.loadingRect.height);
        this.app.sr.set(ShapeRenderer.ShapeType.Line);
        this.app.sr.rect(this.loadingRect.x, this.loadingRect.y, 853.3333f, this.loadingRect.height);
        this.app.sr.end();
        this.app.sb.begin();
        App.assets.get("badaboom60.ttf", BitmapFont.class).draw((Batch)this.app.sb, "Loading", this.stage.getWidth() / 2.0f - 80.0f, this.loadingRect.y + 80.0f);
        this.app.sb.draw(this.logo, this.stage.getWidth() / 2.0f - (float)(this.logo.getWidth() / 2), this.stage.getHeight() / 1.5f - (float)(this.logo.getHeight() / 2));
        this.app.sb.end();
    }

    @Override
    public void handleInput() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.logo.dispose();
    }

    private void assetsToLoad() {
        this.loadFont("fonts/badaboom.TTF", 25, Color.BLACK);
        this.loadFont("fonts/badaboom.TTF", 30, Color.BLACK);
        this.loadFont("fonts/badaboom.TTF", 45, Color.BLACK);
        App.assets.load("textures/backgrounds/menuBackground.jpg", Texture.class);
        App.assets.load("textures/backgrounds/leaderboardBackground.jpg", Texture.class);
        App.assets.load("textures/backgrounds/levelSelectBackground.jpg", Texture.class);
        App.assets.load("textures/backgrounds/pauseBackground.png", Texture.class);
        App.assets.load("textures/backgrounds/failureBackground.png", Texture.class);
        App.assets.load("textures/backgrounds/successBackground.png", Texture.class);
        App.assets.load("textures/backgrounds/position0.png", Texture.class);
        App.assets.load("textures/backgrounds/position1.png", Texture.class);
        App.assets.load("textures/backgrounds/position2.png", Texture.class);
        for (int i = 1; i <= 10; ++i) {
            App.assets.load("textures/intros/level" + i + "Intro.png", Texture.class);
        }
        App.assets.load("textures/player/player_green.png", Texture.class);
        App.assets.load("textures/player/player_blue.png", Texture.class);
        App.assets.load("textures/player/player_yellow.png", Texture.class);
        App.assets.load("textures/enemies/redAlive.png", Texture.class);
        App.assets.load("textures/enemies/redDead.png", Texture.class);
        App.assets.load("textures/enemies/greenAlive.png", Texture.class);
        App.assets.load("textures/enemies/greenDead.png", Texture.class);
        App.assets.load("textures/enemies/blueAlive.png", Texture.class);
        App.assets.load("textures/enemies/blueDead.png", Texture.class);
        App.assets.load("spritesheets/platformSet.png", Texture.class);
        App.assets.load("music/TheComplex.mp3", Music.class);
        App.assets.load("sounds/jumping.mp3", Sound.class);
        App.assets.load("sounds/colourchange.mp3", Sound.class);
        try {
            FileWriter leaderboard = new FileWriter("Leaderboard.csv", true);
            leaderboard.flush();
            leaderboard.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadFont(String fontFileName, int size, Color borderColour) {
        FreetypeFontLoader.FreeTypeFontLoaderParameter params = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        params.fontFileName = fontFileName;
        params.fontParameters.size = size;
        params.fontParameters.borderWidth = 2.0f;
        params.fontParameters.borderColor = borderColour;
        App.assets.load("badaboom" + size + ".ttf", BitmapFont.class, params);
    }
}

