/*
 * Decompiled with CFR 0.152.
 */
package com.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.game.App;
import com.game.managers.ScreenManager;
import com.game.misc.levelSelectClickListener;
import com.game.screens.AbstractScreen;
import java.util.ArrayList;

public class LevelSelect
extends AbstractScreen {
    private Skin skin;
    private ArrayList<TextButton> butLevels = new ArrayList();
    private TextButton butEndless;
    private TextButton butBack;
    private Vector2 buttonSize;

    public LevelSelect(App app) {
        super(app);
        this.skin = new Skin();
        this.buttonSize = new Vector2(50.0f, 50.0f);
    }

    @Override
    public void show() {
        super.show();
        this.skin.add("default-font", App.assets.get("badaboom60.ttf", BitmapFont.class));
        this.skin.load(Gdx.files.internal("spritesheets/uiskin.json"));
        this.initButtons();
    }

    @Override
    public void update(float dt) {
        this.stage.act(dt);
    }

    @Override
    public void render(float dt) {
        super.render(dt);
        this.app.sb.begin();
        this.app.sb.draw(App.assets.get("textures/backgrounds/levelSelectBackground.jpg", Texture.class), 0.0f, 0.0f);
        this.app.sb.end();
        this.stage.draw();
    }

    @Override
    public void handleInput() {
        if (Gdx.input.isKeyJustPressed(131)) {
            this.app.sm.setScreen(ScreenManager.Screen.MENU);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void initButtons() {
        this.butBack = new TextButton("Back", this.skin, "default");
        this.butBack.setPosition(this.buttonSize.x, this.buttonSize.y / 2.0f);
        this.butBack.setSize(this.buttonSize.x, this.buttonSize.y);
        this.butBack.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                LevelSelect.this.app.sm.setScreen(ScreenManager.Screen.MENU);
            }
        });
        int tempCounter = 1;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 5; ++col) {
                TextButton butTemp = new TextButton(String.valueOf(tempCounter), this.skin, "default");
                butTemp.setPosition(500 + col * 60, 400 - row * 60);
                butTemp.setSize(this.buttonSize.x, this.buttonSize.y);
                butTemp.addListener(new levelSelectClickListener(this.app, tempCounter));
                ++tempCounter;
                this.stage.addActor(butTemp);
                this.butLevels.add(butTemp);
            }
        }
        this.butEndless = new TextButton("Endless Mode", this.skin, "default");
        this.butEndless.setPosition(this.stage.getWidth() / 2.0f - this.buttonSize.x / 2.0f, this.buttonSize.y + 120.0f);
        this.butEndless.setSize(this.buttonSize.x, this.buttonSize.y);
        this.butEndless.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                LevelSelect.this.butEndless.addAction(Actions.forever(Actions.moveBy(20.0f, 3.0f)));
            }
        });
        this.stage.addActor(this.butEndless);
        this.stage.addActor(this.butBack);
    }
}

