/*
 * Decompiled with CFR 0.152.
 */
package com.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.game.App;
import com.game.managers.ScreenManager;
import com.game.screens.AbstractScreen;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;

public class Leaderboard
extends AbstractScreen {
    private Skin skin;
    private Vector2 buttonSize;
    private TextButton butBack;
    private ArrayList<String> leaderboardValues = new ArrayList();

    public Leaderboard(App app) {
        super(app);
        this.skin = new Skin();
        this.buttonSize = new Vector2(50.0f, 50.0f);
    }

    @Override
    public void show() {
        super.show();
        this.leaderboardValues = new ArrayList();
        this.skin.add("default-font", App.assets.get("badaboom45.ttf", BitmapFont.class));
        this.skin.load(Gdx.files.internal("spritesheets/uiskin.json"));
        try {
            Scanner scanner = new Scanner(new File("Leaderboard.csv"));
            scanner.useDelimiter(",");
            while (scanner.hasNext()) {
                this.leaderboardValues.add(scanner.next());
            }
            System.out.println(this.leaderboardValues);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.initButtons();
    }

    @Override
    public void update(float dt) {
        this.stage.act(dt);
    }

    @Override
    public void render(float dt) {
        super.render(dt);
        this.app.sb.begin();
        this.app.sb.draw(App.assets.get("textures/backgrounds/leaderboardBackground.jpg", Texture.class), 0.0f, 0.0f);
        int count = 0;
        for (int col = 0; col < this.leaderboardValues.size() / 2; ++col) {
            for (int row = 0; row < 2; ++row) {
                App.assets.get("badaboom45.ttf", BitmapFont.class).draw((Batch)this.app.sb, this.leaderboardValues.get(count++), (float)(100 + 400 * row), (float)(500 + -50 * col));
            }
        }
        this.app.sb.end();
        this.stage.draw();
    }

    @Override
    public void handleInput() {
        if (Gdx.input.isKeyJustPressed(131)) {
            this.app.sm.setScreen(ScreenManager.Screen.MENU);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void initButtons() {
        this.butBack = new TextButton("Back", this.skin, "default");
        this.butBack.setPosition(this.buttonSize.x, this.buttonSize.y / 2.0f);
        this.butBack.setSize(this.buttonSize.x, this.buttonSize.y);
        this.butBack.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Leaderboard.this.app.sm.setScreen(ScreenManager.Screen.MENU);
            }
        });
        this.stage.addActor(this.butBack);
    }
}

