/*
 * Decompiled with CFR 0.152.
 */
package com.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.game.App;

public abstract class AbstractScreen
implements Screen {
    protected App app;
    protected OrthographicCamera cam;
    protected OrthographicCamera hudCam;
    protected Stage stage;

    public AbstractScreen(App app) {
        this.app = app;
        this.cam = new OrthographicCamera();
        this.cam.setToOrtho(false, 1280.0f, 720.0f);
        this.hudCam = new OrthographicCamera();
        this.hudCam.setToOrtho(false, 1280.0f, 720.0f);
        this.stage = new Stage();
    }

    @Override
    public void show() {
        System.out.println("Showing screen: " + this.getClass().getSimpleName());
        Gdx.input.setInputProcessor(this.stage);
    }

    public abstract void update(float var1);

    @Override
    public void render(float dt) {
        this.handleInput();
        this.update(dt);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.app.sb.setProjectionMatrix(this.cam.combined);
    }

    public abstract void handleInput();

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        Gdx.input.setInputProcessor(null);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        System.out.println("Disposing screen: " + this.getClass().getSimpleName());
    }
}

