/*
 * Decompiled with CFR 0.152.
 */
package com.game.misc.utils;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class CameraUtils {
    public static void lerpToTarget(Camera cam, float tarX, float tarY) {
        Vector3 pos = cam.position;
        pos.x = cam.position.x + (tarX - cam.position.x) * 0.2f;
        pos.y = cam.position.y + (tarY - cam.position.y) * 0.2f;
        cam.position.set(pos);
        cam.update();
    }

    public static void setBoundary(Camera cam, Vector2 start, Vector2 size) {
        Vector3 pos = cam.position;
        if (pos.x < start.x) {
            pos.x = start.x;
        }
        if (pos.x > start.x + size.x) {
            pos.x = start.x + size.x;
        }
        if (pos.y < start.y) {
            pos.y = start.y;
        }
        if (pos.y > start.y + size.y) {
            pos.y = start.y + size.y;
        }
        cam.position.set(pos);
        cam.update();
    }
}

