/*
 * Decompiled with CFR 0.152.
 */
package com.game.misc.utils;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;

public class Box2dUtils {
    private static float density = 1.0f;
    private static float friction = 0.9f;

    public static Body makeBody(World world, BodyDef.BodyType bodyType, Vector2 pos) {
        BodyDef bd = new BodyDef();
        bd.type = bodyType;
        bd.position.set(pos.x / 100.0f, pos.y / 100.0f);
        return world.createBody(bd);
    }

    public static void makePolygon(Body body, Vector2 size, String userData, boolean isSensor, short categoryBits, short maskBits) {
        FixtureDef fd = new FixtureDef();
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(size.x / 2.0f / 100.0f, size.y / 2.0f / 100.0f);
        fd.shape = shape;
        fd.density = density;
        fd.friction = friction;
        fd.filter.categoryBits = categoryBits;
        fd.filter.maskBits = maskBits;
        fd.isSensor = isSensor;
        if (userData.equals("")) {
            body.createFixture(fd);
        } else {
            body.createFixture(fd).setUserData(userData);
        }
    }

    public static void makeCircle(Body body, float diameter, String userData, boolean isSensor, short categoryBits, short maskBits) {
        FixtureDef fd = new FixtureDef();
        CircleShape shape = new CircleShape();
        shape.setRadius(diameter / 2.0f / 100.0f);
        fd.shape = shape;
        fd.density = density;
        fd.friction = friction;
        fd.filter.categoryBits = categoryBits;
        fd.filter.maskBits = maskBits;
        fd.isSensor = isSensor;
        if (userData.equals("")) {
            body.createFixture(fd);
        } else {
            body.createFixture(fd).setUserData(userData);
        }
    }

    public static void makeChain(Body body, Vector2[] v, String userData, boolean isSensor, short categoryBits, short maskBits) {
        FixtureDef fd = new FixtureDef();
        ChainShape shape = new ChainShape();
        shape.createChain(v);
        fd.shape = shape;
        fd.density = density;
        fd.friction = friction;
        fd.filter.categoryBits = categoryBits;
        fd.filter.maskBits = maskBits;
        fd.isSensor = isSensor;
        if (userData.equals("")) {
            body.createFixture(fd);
        } else {
            body.createFixture(fd).setUserData(userData);
        }
    }
}

