/*
 * Decompiled with CFR 0.152.
 */
package com.game.managers;

import com.game.App;
import com.game.screens.AbstractScreen;
import com.game.screens.Leaderboard;
import com.game.screens.LevelSelect;
import com.game.screens.Loading;
import com.game.screens.Menu;
import com.game.screens.Play;
import java.util.HashMap;

public class ScreenManager {
    private final App app;
    private HashMap<Screen, AbstractScreen> screens = new HashMap();

    public ScreenManager(App app) {
        this.app = app;
        this.initScreens();
    }

    private void initScreens() {
        this.screens.put(Screen.LOADING, new Loading(this.app));
        this.screens.put(Screen.MENU, new Menu(this.app));
        this.screens.put(Screen.LEADERBOARD, new Leaderboard(this.app));
        this.screens.put(Screen.LEVELSELECT, new LevelSelect(this.app));
    }

    public void setPlayScreen(int levelNumber) {
        if (this.screens.get((Object)Screen.PLAY) != null) {
            this.screens.get((Object)Screen.PLAY).dispose();
            this.screens.remove((Object)Screen.PLAY);
        }
        this.screens.put(Screen.PLAY, new Play(this.app, levelNumber));
        this.setScreen(Screen.PLAY);
    }

    public void setScreen(Screen s) {
        this.app.setScreen(this.screens.get((Object)s));
    }

    public void dispose() {
        for (AbstractScreen s : this.screens.values()) {
            if (s == null) continue;
            s.dispose();
        }
    }

    public static enum Screen {
        LOADING,
        MENU,
        LEADERBOARD,
        LEVELSELECT,
        PLAY,
        ENDLESSMODE;

    }
}

