/*
 * Decompiled with CFR 0.152.
 */
package com.game.actor;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.World;
import com.game.App;
import com.game.actor.Base;
import com.game.misc.Vars;
import com.game.misc.utils.Box2dUtils;

public class Player
extends Base {
    Vector2 curVel;
    private Sprite sprite;
    private Action curAction = Action.IDLE;
    private Sound jumpSound;
    private Sound colourchangeSound;

    public Player(World world, Vector2 pos, Vector2 size, Base.Colours curColour) {
        super(world, pos, size, curColour);
        this.body = Box2dUtils.makeBody(world, BodyDef.BodyType.DynamicBody, pos);
        Box2dUtils.makeCircle(this.body, size.x, "PLAYER", false, (short)1, (short)3);
        this.jumpSound = App.assets.get("sounds/jumping.mp3", Sound.class);
        this.colourchangeSound = App.assets.get("sounds/colourchange.mp3", Sound.class);
        this.sprite = new Sprite(App.assets.get("textures/player/player_red.png", Texture.class));
        this.sprite.setPosition(pos.x * 100.0f - size.x / 2.0f, pos.y * 100.0f - size.y / 2.0f);
    }

    public void update(float dt) {
        if (this.curAction == Action.JUMPING) {
            this.body.applyForceToCenter(new Vector2(0.0f, 65.0f), true);
            this.curAction = Action.FALLING;
        }
        this.curVel = this.body.getLinearVelocity();
        this.curVel.x = Vars.SCROLLSPEED.x * dt;
        this.body.setLinearVelocity(this.curVel);
        this.pos = this.body.getPosition();
        this.sprite.setPosition(this.pos.x * 100.0f - this.size.x / 2.0f, this.pos.y * 100.0f - this.size.y / 2.0f);
        this.sprite.setRotation(this.body.getAngle() * 57.295776f);
    }

    public void render(SpriteBatch sb) {
        this.sprite.draw(sb);
    }

    public void jump() {
        if (this.curAction != Action.FALLING) {
            this.curAction = Action.JUMPING;
            this.jumpSound.play();
        }
    }

    public Action getCurAction() {
        return this.curAction;
    }

    public void setAction(Action curAction) {
        this.curAction = curAction;
    }

    @Override
    public void setCurColour(Base.Colours curColour) {
        super.setCurColour(curColour);
        Filter filter = this.body.getFixtureList().first().getFilterData();
        short bits = filter.maskBits;
        switch (curColour) {
            case RED: {
                bits = (short)(bits & 0xFFFFFFFB);
                bits = (short)(bits & 0xFFFFFFF7);
                bits = (short)(bits | 2);
                this.sprite.setTexture(App.assets.get("textures/player/player_red.png", Texture.class));
                break;
            }
            case GREEN: {
                bits = (short)(bits & 0xFFFFFFFD);
                bits = (short)(bits & 0xFFFFFFF7);
                bits = (short)(bits | 4);
                this.sprite.setTexture(App.assets.get("textures/player/player_green.png", Texture.class));
                break;
            }
            case BLUE: {
                bits = (short)(bits & 0xFFFFFFFD);
                bits = (short)(bits & 0xFFFFFFFB);
                bits = (short)(bits | 8);
                this.sprite.setTexture(App.assets.get("textures/player/player_blue.png", Texture.class));
            }
        }
        filter.maskBits = bits;
        this.body.getFixtureList().first().setFilterData(filter);
        this.colourchangeSound.play();
    }

    public static enum Action {
        IDLE,
        JUMPING,
        FALLING,
        DEAD;

    }
}

