/*
 * Decompiled with CFR 0.152.
 */
package com.game.actor;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.game.App;
import com.game.actor.Base;
import com.game.misc.utils.Box2dUtils;

public class Enemy
extends Base {
    private Sprite sprite;
    private boolean isAlive;

    public Enemy(World world, Vector2 pos, Vector2 size, Base.Colours curColour, short categoryBits, short maskBits) {
        super(world, pos, size, curColour);
        this.body = Box2dUtils.makeBody(world, BodyDef.BodyType.StaticBody, pos);
        Box2dUtils.makePolygon(this.body, size, "ENEMY", true, categoryBits, maskBits);
        this.isAlive = true;
        this.sprite = new Sprite(App.assets.get("textures/enemies/redAlive.png", Texture.class));
        this.sprite.setPosition(pos.x - size.x / 2.0f, pos.y - size.y / 2.0f);
        this.setCurColour(curColour);
    }

    public void render(SpriteBatch sb) {
        this.sprite.draw(sb);
    }

    @Override
    public void setCurColour(Base.Colours curColour) {
        super.setCurColour(curColour);
        Filter filter = this.body.getFixtureList().first().getFilterData();
        short bits = filter.maskBits;
        switch (curColour) {
            case RED: {
                bits = (short)(bits & 0xFFFFFFFB);
                bits = (short)(bits & 0xFFFFFFF7);
                bits = (short)(bits | 2);
                if (this.isAlive) {
                    this.sprite.setTexture(App.assets.get("textures/enemies/redAlive.png", Texture.class));
                    break;
                }
                this.sprite.setTexture(App.assets.get("textures/enemies/redDead.png", Texture.class));
                break;
            }
            case GREEN: {
                bits = (short)(bits & 0xFFFFFFFD);
                bits = (short)(bits & 0xFFFFFFF7);
                bits = (short)(bits | 4);
                if (this.isAlive) {
                    this.sprite.setTexture(App.assets.get("textures/enemies/greenAlive.png", Texture.class));
                    break;
                }
                this.sprite.setTexture(App.assets.get("textures/enemies/greenDead.png", Texture.class));
                break;
            }
            case BLUE: {
                bits = (short)(bits & 0xFFFFFFFD);
                bits = (short)(bits & 0xFFFFFFFB);
                bits = (short)(bits | 8);
                if (this.isAlive) {
                    this.sprite.setTexture(App.assets.get("textures/enemies/blueAlive.png", Texture.class));
                    break;
                }
                this.sprite.setTexture(App.assets.get("textures/enemies/blueDead.png", Texture.class));
            }
        }
        filter.maskBits = bits;
        this.body.getFixtureList().first().setFilterData(filter);
    }

    public void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public Array<Fixture> getFixtures() {
        return this.body.getFixtureList();
    }
}

